﻿using Jeneva;

namespace MyClients.Validation.Common.Impl
{
    public class ValidationContext : Jeneva.Validation.Impl.JenevaValidationContext, IValidationContext
    {
        public ValidationContext(IJenevaContext jenevaContext)
            : base(jenevaContext)
        {
        }

        public void Required()
        {
            this.Assigned("is required");
            if (this.IsFieldValid && this.IsValidFormat())
            {
                this.NotNull("is required");
            }
        }

        public void Missing()
        {
            this.NotAssigned("must be empty");
        }

        public void Number()
        {
            this.ValidFormat("must be valid number");
        }

        public void Date()
        {
            this.ValidFormat("must be valid date");
        }

        public void Float()
        {
            this.ValidFormat("must be valid floating point number");
        }

        public void Email()
        {
            const string expr = @"\b[A-Z0-9._%+-]+@[A-Z0-9.-]+\.[A-Z]{2,4}\b";
            this.Regex(expr, "must be valid Email");
        }

        public void Text()
        {
            this.StringLengthBetween(3, 20, "must be between 3 and 20 characters");
        }

        public void TrueFalse()
        {
            this.ValidFormat("must be 'yes' or 'no'");
        }
    }
}